//---------------------------
// UCL-CEREM-MBS
//
// @version MBsysLab_s 1.7.a
//
// Creation : 2006
// Last update : 01/10/2008
//---------------------------

#include "math.h"
#include "user_IO.h"
#include "mbs_data.h"
#include "set_output.h"
#include "user_model.h"
#include "user_all_id.h"

double user_LinkForces(double Z, double Zd, MbsData *mbs_data, double tsim, int ilnk)
{
    double K  = mbs_data->user_model->SUSP.K;
    double C  = mbs_data->user_model->SUSP.C;
    double L0 = mbs_data->user_model->SUSP.z0;

    double Fspring = K*(Z-L0);
    double Fdamper = C*Zd;
    set_output(L0 , "L0");
    set_output(Fspring , "Fspring");
    set_output(Fdamper , "Fdamper");
    double Flink = Fspring + Fdamper;
    return Flink;
	
}
